function writeNAM(basename,nam)
% writeNAM(basename,namfiles)
% namfiles is cell array with headers and per line PARNAME, UNIT, BASENAME EXT EXISTFLAG
% TO 070630 100120


% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

fmt='%-15s%5d %s.%s\n';    % for nam file
fms='"%s\\%s%s" %s.nam\n';  % for batfile

hdr=sprintf('%s\n',['# MATLAB       writeNAM ' datestr(now)]);
    fprintf('%s\n',['# MODFLOW etc. writeNAM ' datestr(now)]);

% get file base name, extension and path of the models for which to generate input 
[MFP, MF , MFE]=fileparts(nam.MF);
fidMF =fopen([MF, '.nam'],'wt');
fprintf(fidMF ,'%s',hdr);

%% 1:  MF bat and nam file
for i=1:length(nam.PCKG)
    if nam.SCEN(i)
        % if package legal in modflow print line to modflow nam file
        if strmatchi(nam.PCKG{i},nam.LegalMF,1)
            fprintf(fidMF,fmt,nam.PCKG{i},nam.UNIT(i),basename,nam.EXT{i});
        end
    end
end
fclose(fidMF);

% mf batfile
fidMF=fopen([MF,'.bat'],'wt');
fprintf(fidMF,fms,MFP,MF,MFE,MF);
fclose(fidMF);


%% 2: MT3D bat and nam file

if strmatch('BTN',nam.PCKG)
    [MTP, MT , MTE]=fileparts(nam.MT);
    fidMT =fopen([MT(1:end-1), '.nam'],'wt');  % remove trailing s or b of namfilename for mt3d
    fprintf(fidMT ,'%s',hdr);
    %1
    for i=1:length(nam.PCKG)
        if nam.SCEN(i)
            % if legal in MT3D print this package to MT3D nam file
            if strmatchi('BTN',nam.PCKG) && strmatchi(nam.PCKG{i},nam.LegalMT,1) % MT incorporates MF
                fprintf(fidMT,fmt,nam.PCKG{i},nam.UNIT(i),basename,nam.EXT{i});
            end
        end
    end
    fclose(fidMT);
    
    % MT3D batfile
    fidMT=fopen([MT,'.bat'],'wt');
    fprintf(fidMT,fms,MFP,MF,MFE,MF);
    fprintf(fidMT,fms,MTP,MT,MTE,MT(1:end-1));
    fclose(fidMT);
end

%% 3: SWT bat and nam file
ivdf=strmatchi('VDF',nam.PCKG,1);  % locate VDF line in NAM
ivsc=strmatchi('VSC',nam.PCKG,1);  % locate VSC line in NAM
if nam.runSWT || ivdf
    [SWTP,SWT,SWTE]=fileparts(nam.SWT);
    fidSWT=fopen([SWT,'.nam'],'wt');
    fprintf(fidSWT,'%s',hdr);
    %1
    for i=1:length(nam.PCKG)
        if nam.SCEN(i)
            % if this package legal in seawat, print this line to the seawater nam file       % nam file
            if  strmatchi(nam.PCKG{i},nam.LegalSWT,1)
                if strcmp(nam.PCKG{i},'LMT6') || strcmp(nam.PCKG{i},'FTL')
                    % skip
                else
                    if i==ivdf && nam.SCEN(ivdf)<0, fprintf(fidSWT,'#'); end  % make vdf line a comment
                    if i==ivsc && nam.SCEN(ivdf)<0, fprintf(fidSWT,'#'); end  % make vsc line a comment
                    
                    fprintf(fidSWT,fmt,nam.PCKG{i},nam.UNIT(i),basename,nam.EXT{i});
                end
            end
        end
    end
    fclose(fidSWT);
    
    % SWT batfile
    fidSWT=fopen([SWT,'.bat'],'wt');
    fprintf(fidSWT,fms,SWTP,SWT,SWTE,SWT);
    fclose(fidSWT);
end

%% 4: SWI bat and nam file
if strmatch('SWI',nam.PCKG)
    [SWIP, SWI,SWIE]=fileparts(nam.SWI);
    fidSWI=fopen([SWI,'.nam'],'wt');
    fprintf(fidSWI,'%s',hdr);
    %1
    for i=1:length(nam.PCKG)
        if nam.SCEN(i)
            % if this package legal in swi the print this line to swi to seawater nam file       % nam file
            if strmatchi('SWI',nam.PCKG) && strmatchi(nam.PCKG{i},nam.LegalSWI,1)
                fprintf(fidSWI,fmt,nam.PCKG{i},nam.UNIT(i),basename,nam.EXT{i});
            end
        end
    end
    fclose(fidSWI);

    % SWI batfile
    fidSWI=fopen([SWI,'.bat'],'wt');
    fprintf(fidSWI,'"%s\\%s%s" < SWInamfilename.txt\n',SWIP,SWI,SWIE);
    fclose(fidSWI);
    
    if ~exist('SWInamfilename.txt','file')
        fid=fopen('SWInamfilename.txt','wt');
        fprintf(fid,'%s.nam\n',SWI);
        fclose(fid);
    end
end
